/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.JposRegPopulator;
import jpos.util.JposEntryUtility;

public class SimpleEntry
implements JposEntry,
Serializable,
Comparable {
    private Hashtable properties = new Hashtable();
    private transient JposRegPopulator regPopulator = null;
    public static final long serialVersionUID = 6937048853319310114L;

    public SimpleEntry() {
        this.regPopulator = null;
    }

    public SimpleEntry(JposRegPopulator jposRegPopulator) {
        this.regPopulator = jposRegPopulator;
    }

    public SimpleEntry(String string, JposRegPopulator jposRegPopulator) {
        this(jposRegPopulator);
        this.addProperty("logicalName", string);
    }

    SimpleEntry(String string) {
        this.addProperty("logicalName", string);
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public Enumeration getPropertyNames() {
        return this.properties.keys();
    }

    public boolean hasPropertyWithName(String string) {
        return this.properties.containsKey(string);
    }

    public boolean hasPropertyWithValue(Object object) {
        return this.properties.contains(object);
    }

    public Object getPropertyValue(String string) {
        return this.properties.get(string);
    }

    public Class getPropertyType(String string) {
        return this.getPropertyValue(string).getClass();
    }

    public Object modifyPropertyValue(String string, Object object) throws IllegalArgumentException {
        SimpleEntry.checkNull(string);
        SimpleEntry.checkNull(object);
        if (!this.hasPropertyWithName(string)) {
            return null;
        }
        Object object2 = this.removeProperty(string);
        this.addProperty(string, object);
        return object2;
    }

    public Object addProperty(String string, Object object) throws IllegalArgumentException {
        SimpleEntry.checkNull(string);
        SimpleEntry.checkNull(object);
        return this.properties.put(string, object);
    }

    public Object removeProperty(String string) {
        return this.properties.remove(string);
    }

    public boolean equals(JposEntry jposEntry) {
        if (jposEntry == null) {
            return false;
        }
        if (this.getPropertyCount() != jposEntry.getPropertyCount()) {
            return false;
        }
        Enumeration enumeration = jposEntry.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = jposEntry.getPropertyValue(string);
            if (!this.hasPropertyWithName(string)) {
                return false;
            }
            if (this.getPropertyValue(string).equals(object)) continue;
            return false;
        }
        return true;
    }

    public JposEntry copy() {
        SimpleEntry simpleEntry = new SimpleEntry();
        Enumeration enumeration = this.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            simpleEntry.addProperty(string, this.getPropertyValue(string));
        }
        return simpleEntry;
    }

    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    public String getLogicalName() {
        return (String)this.getPropertyValue("logicalName");
    }

    public JposEntry.Prop getProp(String string) {
        Object object = this.getPropertyValue(string);
        if (object == null) {
            return null;
        }
        return new Prop(string, object);
    }

    public Iterator getProps() {
        ArrayList<Prop> arrayList = new ArrayList<Prop>();
        Enumeration enumeration = this.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(new Prop(string, this.getPropertyValue(string)));
        }
        return arrayList.iterator();
    }

    public void add(JposEntry.Prop prop) throws IllegalArgumentException {
        SimpleEntry.checkNull(prop);
        this.addProperty(prop.getName(), prop.getValue());
    }

    public void remove(JposEntry.Prop prop) {
        this.removeProperty(prop.getName());
    }

    public void modify(JposEntry.Prop prop) throws IllegalArgumentException {
        SimpleEntry.checkNull(prop);
        if (!this.hasPropertyWithName(prop.getName())) {
            return;
        }
        this.modifyPropertyValue(prop.getName(), prop.getValue());
    }

    public boolean hasProp(JposEntry.Prop prop) {
        return this.hasPropertyWithName(prop.getName());
    }

    public JposEntry.Prop createProp(String string, Object object, Class clazz) throws JposConfigException {
        if (string == null || object == null || clazz == null) {
            throw new JposConfigException("Cannot create JposEntry.Prop with null argument");
        }
        if (!JposEntryUtility.validatePropValue(object, clazz)) {
            throw new JposConfigException("Cannot create JposEntry.Prop with invalid value or type");
        }
        return new Prop(string, object);
    }

    public boolean equals(Object object) {
        if (object instanceof JposEntry) {
            return this.equals((JposEntry)object);
        }
        return false;
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof JposEntry)) {
            throw new RuntimeException("Cannot compare: " + object + " with JposEntry: " + this);
        }
        JposEntry jposEntry = (JposEntry)object;
        if (this.equals(jposEntry)) {
            return 0;
        }
        return this.getLogicalName().compareTo(jposEntry.getLogicalName());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<JposEntry logicalName=\"" + this.getPropertyValue("logicalName") + "\">\n");
        stringBuffer.append("\t<creation factoryClass=\"" + this.getPropertyValue("serviceInstanceFactoryClass") + "\" serviceClass=\"" + this.getPropertyValue("serviceClass") + "\"/>\n");
        stringBuffer.append("\t<vendor name=\"" + this.getPropertyValue("vendorName") + "\" url=" + this.getPropertyValue("vendorURL") + "\"/>\n");
        stringBuffer.append("\t<jpos category=\"" + this.getPropertyValue("deviceCategory") + "\" version=\"" + this.getPropertyValue("jposVersion") + "\"/>\n");
        stringBuffer.append("\t<product description=\"" + this.getPropertyValue("productDescription") + "\" name=\"" + this.getPropertyValue("productName") + "\" url=\"" + this.getPropertyValue("productURL") + "\"/>\n");
        stringBuffer.append("\n");
        Enumeration enumeration = JposEntryUtility.getNonRequiredPropNames(this);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getPropertyValue(string).toString();
            String string3 = JposEntryUtility.shortClassName(string2.getClass());
            stringBuffer.append("\t<prop name=\"" + string + "\" value=\"" + string2 + "\" type=\"" + string3 + "\"/>\n");
        }
        stringBuffer.append("</JposEntry>\n");
        return stringBuffer.toString();
    }

    void setRegPopulator(JposRegPopulator jposRegPopulator) {
        this.regPopulator = jposRegPopulator;
    }

    protected static void checkNull(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Invalid null argument passed for a JposEntry property value or name");
        }
    }

    public static class Prop
    implements JposEntry.Prop,
    Comparable {
        private String name = "";
        private Object value = null;
        private Class typeClass = null;

        public Prop(String string, Object object) throws IllegalArgumentException {
            SimpleEntry.checkNull(string);
            SimpleEntry.checkNull(object);
            this.name = string;
            this.value = object;
            this.typeClass = object.getClass();
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueAsString() {
            return String.valueOf(this.value);
        }

        public Class getType() {
            return this.typeClass;
        }

        public void setName(String string) throws IllegalArgumentException {
            SimpleEntry.checkNull(string);
            this.name = string;
        }

        public void setValue(Object object) throws IllegalArgumentException {
            SimpleEntry.checkNull(object);
            if (!JposEntryUtility.validatePropValue(object, object.getClass())) {
                throw new IllegalArgumentException("Cannot set property named = " + this.getName() + " with value = " + object + " invalid value or type");
            }
            this.setValue(object, object.getClass());
        }

        public boolean isOfType(Class clazz) {
            if (clazz == null || this.typeClass == null) {
                return false;
            }
            return this.typeClass.equals(clazz);
        }

        public JposEntry.Prop copy() {
            return new Prop(this.getName(), this.getValue());
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof JposEntry.Prop)) {
                return false;
            }
            JposEntry.Prop prop = (JposEntry.Prop)object;
            return this.getName().equals(prop.getName()) && this.getValue().equals(prop.getValue());
        }

        public int compareTo(Object object) {
            if (object == null || !(object instanceof JposEntry.Prop)) {
                throw new RuntimeException("Cannot compare: " + object + " with JposEntry.Prop: " + this);
            }
            JposEntry.Prop prop = (JposEntry.Prop)object;
            if (this.equals(prop)) {
                return 0;
            }
            return this.getName().compareTo(prop.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        private void setValue(Object object, Class clazz) throws IllegalArgumentException {
            SimpleEntry.checkNull(object);
            SimpleEntry.checkNull(clazz);
            if (!object.getClass().equals(clazz)) {
                throw new IllegalArgumentException("Value and value type not in agreement for property named = " + this.name);
            }
            this.value = object;
            this.typeClass = clazz;
        }
    }
}

